/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.Function;
import intrinsic.mx.controls.NumericStepper;
import intrinsic.mx.events.NumericStepperEvent;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Point;

public class Spinner extends Composite {

public Spinner (Composite parent, int style) {
	super (parent, checkStyle (style));
}

static int checkStyle (int style) {
	/*
	* Even though it is legal to create this widget
	* with scroll bars, they serve no useful purpose
	* because they do not automatically scroll the
	* widget's client area.  The fix is to clear
	* the SWT style.
	*/
	return style & ~(SWT.H_SCROLL | SWT.V_SCROLL);
}

protected void checkSubclass () {
	if (!isValidSubclass ()) error (SWT.ERROR_INVALID_SUBCLASS);
}

public void addModifyListener (ModifyListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	TypedListener typedListener = new TypedListener (listener);
	addListener (SWT.Modify, typedListener);
}

public void addSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	TypedListener typedListener = new TypedListener (listener);
	addListener (SWT.Selection,typedListener);
	addListener (SWT.DefaultSelection,typedListener);
}

public Point computeSize (int wHint, int hHint, boolean changed) {
	checkWidget ();
	return computeNativeSize (object, wHint, hHint, changed);
}

public void copy () {
	checkWidget ();
}

void createHandle () {
	NumericStepper widget = new NumericStepper ();
	object = widget;
}

void createWidget() {
	super.createWidget ();
	setValues (0, 0, 100, 0, 1, 10);
}

public void cut () {
	checkWidget ();
}

public int getDigits () {
	checkWidget ();
	//TODO
	return (int)((NumericStepper)object).stepSize;
}

public int getIncrement () {
	checkWidget ();
	return 1;
}

public int getMaximum () {
	checkWidget ();
	return (int)((NumericStepper)object).maximum;
}

public int getMinimum () {
	checkWidget ();
	return (int)((NumericStepper)object).minimum;
}

public int getPageIncrement () {
	checkWidget ();
	return 10;
}

public int getSelection () {
	checkWidget ();
	return (int)((NumericStepper)object).value;
}

void handleChange (NumericStepperEvent event) {
	postEvent (SWT.Selection);
}

native Function handleChangeFunction ()/*{
	return handleChange__Lmx_events_NumericStepperEvent_2;
}*/;

void hookEvents() {
	super.hookEvents();
	object.addEventListener(NumericStepperEvent.CHANGE, handleChangeFunction ());
}

public void paste () {
	checkWidget ();
}

public void removeModifyListener (ModifyListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (eventTable == null) return;
	eventTable.unhook (SWT.Modify, listener);	
}

public void removeSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (eventTable == null) return;
	eventTable.unhook (SWT.Selection, listener);
	eventTable.unhook (SWT.DefaultSelection,listener);	
}

boolean sendKeyEvent (int type, Event keyEvent) {
	boolean result = super.sendKeyEvent(type, keyEvent);
	if (isDisposed ()) return false;
	if (!result) return result;
	if (type != SWT.KeyDown) return result;
	switch (keyEvent.keyCode) {
		case SWT.CR:
			postEvent(SWT.DefaultSelection);
			break;
	}
	return result;
}


public void setDigits (int value) {
	checkWidget ();
	((NumericStepper)object).stepSize = value == 0 ? 1 : 1 / Math.pow(10, value);
}

public void setIncrement (int value) {
	checkWidget ();
}

public void setMaximum (int value) {
	checkWidget ();
	((NumericStepper)object).maximum = value;
}

public void setMinimum (int value) {
	checkWidget ();
	((NumericStepper)object).minimum = value;
}

public void setPageIncrement (int value) {
	checkWidget ();
}

public void setSelection (int value) {
	checkWidget ();
	((NumericStepper)object).value = value;
}

public void setValues (int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
	checkWidget ();
	if (minimum < 0) return;
	if (maximum <= minimum) return;
	if (digits < 0) return;
	if (increment < 1) return;
	if (pageIncrement < 1) return;
	selection = Math.min (Math.max (minimum, selection), maximum);
	NumericStepper widget = (NumericStepper)object;
	widget.minimum = minimum;
	widget.maximum = maximum;
	widget.value = selection;
	widget.stepSize = digits == 0 ? 1 : 1 / Math.pow(10, digits);
//	this.pageIncrement = pageIncrement;
//	this.increment = increment;
}

}
